/*

    File: swap.c

    Copyright (C) 1998-2004 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */
#include <string.h>
#include "types.h"
#include "common.h"
#include "swap.h"
#include "fnctdsk.h"

int check_Linux_SWAP(t_param_disk *disk_car,t_diskext *partition,const int debug)
{
  unsigned char buffer[8*SECTOR_SIZE];
  if(disk_car->read(disk_car,8, &buffer, partition->lba)!=0)
  { return 1; }
  if(test_Linux_SWAP(disk_car,(union swap_header*)&buffer,partition,debug,0)!=0)
    return 1;
  return 0;
}

int test_Linux_SWAP(t_param_disk *disk_car, const union swap_header *swap_header,t_diskext *partition,const int debug, const int dump_ind)
{
  if(memcmp(swap_header->magic.magic,"SWAP-SPACE",10)==0)
  {
    partition->upart_type=UP_LINSWAP;
    return 0;
  }
  if(memcmp(swap_header->magic.magic,"SWAPSPACE2",10)==0)
  {
    partition->upart_type=UP_LINSWAP2;
    return 0;
  }
  return 1;
}

int recover_Linux_SWAP(t_param_disk *disk_car, const union swap_header *swap_header,t_diskext *partition,const int debug, const int dump_ind)
{
  if(test_Linux_SWAP(disk_car,swap_header,partition,debug,dump_ind)!=0)
    return 1;
  partition->part_type=(unsigned char)P_LINSWAP;
  switch(partition->upart_type)
  {
    case UP_LINSWAP:
      {
	int i, j;
	for(i=PAGE_SIZE-10-1;i>=0;i--)
	  if(swap_header->magic.reserved[i]!=(char)0)
	    break;
	for(j=7;j>=0;j--)
	  if((swap_header->magic.reserved[i]&(1<<j))!=(char)0)
	    break;
	partition->part_size=(dword)((8*i+j+1)*(PAGE_SIZE/SECTOR_SIZE));
	if(debug>1)
	  ecrit_rapport("SWAP version %u\n",swap_header->info.version);
      }
      break;
    case UP_LINSWAP2:
      partition->part_size=(swap_header->info.last_page - 1)*(PAGE_SIZE/SECTOR_SIZE);
      if(debug>1)
	ecrit_rapport("SWAP2 version %u\n",swap_header->info.version);
      break;
    default:
      return 1;
  }
  return 0;
}
