struct ntfs_boot_sector {
	__u8	ignored[3];	/* 0x00 Boot strap short or near jump */
	__s8	system_id[8];	/* 0x03 Name : NTFS */
	__u8	sector_size[2];	/* 0x0B bytes per logical sector */
	__u8	cluster_size;	/* 0x0D sectors/cluster */
	__u16	reserved;	/* 0x0E reserved sectors = 0 */
	__u8	fats;		/* 0x10 number of FATs = 0 */
	__u8	dir_entries[2];	/* 0x11 root directory entries = 0 */
	__u8	sectors[2];	/* 0x13 number of sectors = 0 */
	__u8	media;		/* 0x15 media code (unused) */
	__u16	fat_length;	/* 0x16 sectors/FAT = 0 */
	__u16	secs_track;	/* 0x18 sectors per track */
	__u16	heads;		/* 0x1A number of heads */
	__u32	hidden;		/* 0x1C hidden sectors (unused) */
	__u32	total_sect;	/* 0x20 number of sectors = 0 */
	__u8	physical_drive;	/* 0x24 physical drive number  */
	__u8	unused;		/* 0x25 */
	__u16	reserved2;	/* 0x26 usually 0x80 */
	__u64	sectors_nbr;	/* 0x28 total sectors nbr */
	__u64	mft_cluster;	/* 0x30 */
	__u64	mftbak_cluster;	/* 0x38 */
	__s32   clusters_frs;	/* 0x40 */
	__s32	clusters_record;	/* 0x44 clusters per index block */
	__u8	nothing[0x1B6];	/* 0x40 */
	__u16	marker;		/* 0x1FE */
};
int set_NTFS_info(t_param_disk *disk_car, const struct ntfs_boot_sector*ntfs_header,t_diskext *partition,const int debug, const int dump_ind);
int recover_NTFS(t_param_disk *disk_car, const struct ntfs_boot_sector*ntfs_header,t_diskext *partition,const int debug, const int dump_ind, const int backup);
int check_NTFS(t_param_disk *disk_car,t_diskext *partition,const int debug,const int dump_ind);
int test_NTFS(const t_param_disk *disk_car,const struct ntfs_boot_sector*ntfs_header, t_diskext *partition,const int debug, const int dump_ind);
int dir_ntfs(WINDOW *window,t_param_disk *disk_car,t_diskext *partition);
int is_ntfs(const int part_type);
int dump_2ntfs_rapport(const struct ntfs_boot_sector *nh1, const struct ntfs_boot_sector *nh2);
int dump_ntfs_rapport(const struct ntfs_boot_sector *ntfs_header);
int dir_partition_ntfs(WINDOW *window,t_param_disk *disk_car,t_diskext *partition, const int debug);
