/*

    File: add_part.c

    Copyright (C) 1998-2004 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>	/* geteuid */
#include "types.h"
#include "common.h"
#include "intrface.h"
#include "fnctdsk.h"

t_list_part *add_partition(t_param_disk *disk_car,t_list_part *list_part, const int debug)
{
  t_CHS start,end;
  t_diskext *new_partition=partition_new();
  int position=0;
  start.cylinder=0;
  start.head=0;
  start.sector=1;
  end.cylinder=disk_car->CHS.cylinder;
  end.head=disk_car->CHS.head;
  end.sector=disk_car->CHS.sector;
  {
    int done = FALSE;
    while (done==FALSE) {
      int command;
      static struct MenuItem menuGeometry[]=
      {
	{ 'c', "Cylinders", 	"Change starting cylinder" },
	{ 'h', "Heads", 	"Change starting head" },
	{ 's', "Sectors", 	"Change starting sector" },
	{ 'C', "Cylinders", 	"Change ending cylinder" },
	{ 'H', "Heads", 	"Change ending head" },
	{ 'S', "Sectors", 	"Change ending sector" },
	{ 'T' ,"Type",		"Change partition type"},
	{ 'd', "Done", "" },
	{ 0, NULL, NULL }
      };
      aff_copy(stdscr);
      wmove(stdscr,4,0);
      wdoprintf(stdscr,"%s",disk_car->description(disk_car));
      new_partition->lba=CHS2LBA(disk_car,&start);
      new_partition->part_size=CHS2LBA(disk_car,&end) - new_partition->lba + 1;
      wmove(stdscr,10, 0);
      wclrtoeol(stdscr);
      aff_part(stdscr,AFF_PART_SHORT,disk_car,new_partition);
      wmove(stdscr,COMMAND_LINE_Y, COMMAND_LINE_X);
      wclrtoeol(stdscr);
      wrefresh(stdscr);
      command=wmenuSimple(stdscr,menuGeometry, position);
      switch (command) {
	case 'c':
	  start.cylinder=ask_number(start.cylinder,0,disk_car->CHS.cylinder,"Enter the starting cylinder ");
	  position=1;
	  break;
	case 'h':
	  start.head=ask_number(start.head,0,disk_car->CHS.head,"Enter the starting head ");
	  position=2;
	  break;
	case 's':
	  start.sector=ask_number(start.sector,1,disk_car->CHS.sector,"Enter the starting sector ");
	  position=3;
	  break;
	case 'C':
	  end.cylinder=ask_number(end.cylinder,start.cylinder,disk_car->CHS.cylinder,"Enter the ending cylinder ");
	  position=4;
	  break;
	case 'H':
	  end.head=ask_number(end.head,0,disk_car->CHS.head,"Enter the ending head ");
	  position=5;
	  break;
	case 'S':
	  end.sector=ask_number(end.sector,1,disk_car->CHS.sector,"Enter the ending sector ");
	  position=6;
	  break;
	case 'T':
	case 't':
	  change_part_type(disk_car,new_partition);
	  position=7;
	  break;
	case key_ESC:
	case 'd':
	case 'D':
	case 'q':
	case 'Q':
	  done = TRUE;
	  break;
      }
    }
  }
  if((CHS2LBA(disk_car,&end)>new_partition->lba)&&(new_partition->lba>0))
  {
    t_list_part *new_list_part=insert_new_partition(list_part, new_partition);
    if(test_structure(list_part)==0)
    { /* Determine if the partition can be Logical, Bootable or Primary */
      if(can_be_ext(disk_car,new_partition)!=0)
      {
	new_partition->status=STATUS_LOG;
	if(test_structure(new_list_part)==0)
	  return new_list_part;
      }
      new_partition->status=STATUS_PRIM_BOOT;
      if(test_structure(new_list_part)==0)
	return new_list_part;
      new_partition->status=STATUS_PRIM;
      if(test_structure(new_list_part)==0)
	return new_list_part;
      new_partition->status=STATUS_DELETED;
    }
    return new_list_part;
  }
  FREE(new_partition);
  return list_part;
}

