
#include <dpmi.h>

	/*  include file for raw disk I/O for __DJGPP__ DOS  */
	/*    by Eric Auer, inspired by disklib - 11/2002    */
	/* * DOES NOT WRITE YET * FAT32 read added 12/2003 * */
	/*   *********************************************   */


/* movedatal(srcSel,srcOfs, dstSel,dstOfs, count): count * dd move */
/* movedatab(...,count): count bytes ... movedataw(...) similar... */

#pragma pack(1) /* needed for the following struct */
struct DCB {
    __u32  sector;
    __u16  number;
    void  *buffer;
}; /* control block for the > 32 MB disk access with "int" 25/26h */
#pragma pack()
            
#define _MK_FP(seg)              (void *)(seg << 16)

static char xferbuf[512];    /* *** 512 byte per sector, fixed *** */
static __u32 xfersec = 0xffffffffL; /* secnum currently in xferbuf */

void raw_read(loff_t pos, size_t size, void * data);
void raw_write(loff_t pos, size_t size, void * data);

void raw_read(loff_t pos, size_t size, void * data)
{
   size_t partsize;
   __u32 secnum;
   __dpmi_regs regs;
   int seg, sel, i;
   int bigdisk = 0;
   struct DCB dcb;
   
   /* dosSeg = __dpmi_allocate_dos_memory(paragraphs, selector); */

   if ( (seg = __dpmi_allocate_dos_memory(
                     (512+10+15)>>4, &sel) ) == -1 )
       pdie("RAW_READ out of transfer/DCB buffer memory");
   /* one sector plus one data structure... */
   
   while (size > 0) {

       secnum = pos >> 9;
       if (secnum != xfersec) {

              regs.x.ax = drive;  /* global variable */
              regs.x.cx = 1;           /* one sector */
          if ((drive > 1) || (secnum > 65534)) {
              /* BIGDISK protocol */
              dcb.sector = secnum;  /* sector, 32bit */
              dcb.number = 1;          /* one sector */
              dcb.buffer = _MK_FP(seg)+0;  /* buffer */
              _movedataw(_my_ds(), (unsigned int)&dcb,
                         sel, 512,  /* DCB in buf... */
                         (sizeof(struct DCB)+1)>>1
                        );            /* copy to DOS */
              regs.x.cx = 0xffff;	  /* special */
              regs.x.dx = 0xbeef;          /* UNUSED */
              regs.x.ds = seg;            /* dcb seg */
              regs.x.bx = 512;   /* points to struct */
              bigdisk = 1;
          } else {
              regs.x.cx = 1;           /* one sector */
              regs.x.dx = secnum & 0xffff; /* sector */
              regs.x.ds = seg;         /* buffer seg */
              regs.x.bx = 0;           /* buffer ofs */
          }
          
          __dpmi_int(0x25, &regs); /* DOSdisk access */
          /* luckily, DPMI knows that this is a farcall! */

          if ( (regs.x.flags & 1 /* CY */) && (bigdisk == 1) ) {
              regs.x.ax = 0x7305;
              regs.x.cx = 0xffff;
              regs.x.dx = drive + 1;  /* 1 (ONE) based counting here!!! */
              regs.x.si = 0; /* mode is "read". (low bit set -> write)  */
                             /* in write mode, 3 high bits can contain  */
                             /* a hint value: 1 fat, 2 dir, 3 file data */
              regs.x.bx = 512; /* structure offset. DCB already filled above! */
              regs.x.ds = seg; /* structure segment. DCB as above. */
              __dpmi_int(0x21, &regs);   /* try FAT32 access style */
          }
           
          if (regs.x.flags & 1 /* CY */) {
              printf("DOS 'int' 0x25 sector read error: %x\n",
                  regs.x.ax);
              /* flush buffer (or fill with 0xdeadbeef): */
              for (i = 0; i < 512; i ++) xferbuf[i] = 0;
           } else {
              _movedatal(sel,   0,
                         _my_ds(), (unsigned int)&xferbuf[0],
                         512>>2);   /* copy from DOS */
           }
           xfersec = secnum;

       } else {
#ifdef _IORDEBUG
           /* otherwise, data is still in cache */
           printf(".");
#endif
       }

       /* read up to the sector boundary at most: */
       partsize = ( (size + (pos & 511)) > 512 ) ?
                  512 - (pos & 511) : size;
       memcpy(data, &xferbuf[pos & 511], partsize);

#ifdef RAWRDEBUG
 printf("@%l8.8x->s=%4.4x: memcpy(%8.8p, %8.8p+%3.3x, %3.3x)\n",
        (long int)pos, (int)secnum,
        data, &xferbuf[0],
        (int)(pos & 511), partsize);
#endif

       pos += partsize;  /* next read will be from here */
       size -= partsize; /* we already have done that much */
       data += partsize; /* sigh, forgot that one! */
       /* pos &= ~511L; *** from now on no "beginning in middle" */
       
   }                     /* repeat while still things to do */

   __dpmi_free_dos_memory(sel);  /* release buffers */
   return;
}

void raw_write(loff_t pos, size_t size, void * data)
{
	/* First version will IGNORE write requests and only */
	/* print out logging information in that case!       */
	/* Must read/modify/write if a sector is not fully   */
	/* overwritten, important! Use xferbuf for this...   */
	/* May be better to have a 2nd xferbuf/xfersec var!  */
	
    printf("raw_write(pos=%lld, size=%ld, *data=0x%p) IGNORED\n",
           pos, size, data);
}
