# FORCE_EFI_BOOT

echo -off
# +
# + ============================================================== +
#  Copyright (c) 2021, Intel Corporation.

#  This source code and any documentation accompanying it ("Material") is furnished
#  under license and may only be used or copied in accordance with the terms of that
#  license.  No license, express or implied, by estoppel or otherwise, to any
#  intellectual property rights is granted to you by disclosure or delivery of these
#  Materials.  The Materials are subject to change without notice and should not be
#  construed as a commitment by Intel Corporation to market, license, sell or support
#  any product or technology.  Unless otherwise provided for in the license under which
#  this Material is provided, the Material is provided AS IS, with no warranties of
#  any kind, express or implied, including without limitation the implied warranties
#  of fitness, merchantability, or non-infringement.  Except as expressly permitted by
#  the license for the Material, neither Intel Corporation nor its suppliers assumes
#  any responsibility for any errors or inaccuracies that may appear herein.  Except
#  as expressly permitted by the license for the Material, no part of the Material
#  may be reproduced, stored in a retrieval system, transmitted in any form, or
#  distributed by any means without the express written consent of Intel Corporation.

#  Module Name:  Startup.nsh

#  Abstract:  UEFI Script file for invoking system software updates for 
#  Intel(R) Server Board S2600WF Family.


@echo -off
mode 80 25

:foundimage section is simply to locate the correct drive
if exist .\ipmi.efi then
 goto FOUNDIMAGE
endif
if exist fs0:\ipmi.efi then
 fs0:
 echo Found Update Packages on fs0:
 goto FOUNDIMAGE
endif
if exist fs1:\ipmi.efi then
 fs1:
 echo Found Update Packages on fs1:
 goto FOUNDIMAGE
endif
if exist fs2:\ipmi.efi then
 fs2:
 echo Found Update Packages on fs2:
 goto FOUNDIMAGE
endif
 echo "Unable to find Update Packages".  
 echo "Please mount the drive with the update package".
 echo ""
 goto END
:FOUNDIMAGE



echo "============================================================================================"
echo " "
echo "This utility will update the BMC firmware, system BIOS, ME, FD firmware, FRUSDR and DCPMM FW"
echo " "
echo "      - Intel(R) Server Board S2600WF Family"
echo " "
echo "If you have not read the Readme and Update Instructions file,"
echo "it is highly advisable you do that before continuing with this update."
echo " "
echo "During the full update process, the system will reboot 1 time."
echo "Do NOT power off the system or remove the USB flash drive at any time during"
echo "this process. Doing so may render your system inoperable."
echo " "
echo "Please make sure there is no *.tmp on the USB key before starting updating."
echo " "
echo "============================================================================================="

# Notification
     echo "Checking your current firmware version info"
     echo "......................Please wait............................"
     echo "Reading Current FW on board..."
     iflash32.efi -i
     

echo " "
echo "======================================================================="
echo "Update Sequence:"
echo "1. BMC - No SUT reset after update completes"
echo "2. ME  - No SUT reset after update completes"
echo "3. BIOS- No SUT reset after update completes"
echo "4. FD  - No SUT reset after update completes"
echo "5. FRUSDR - No SUT reset after update completes"
echo " "
echo "!!! Steps 1-5 will be completed at the 1st time run startup.nsh!!!"
echo "Reset SUT to make updated firmware effective."
echo "6. DCPMM FW, if a DCPMM DIMM is installed"
echo "After update, remind user to Reset SUT to make firmware effective"
echo " "
echo "!!! Item 6 will be completed the 2nd time run startup.nsh!!!"
echo " "
echo "See the Readme and Update Instructions file for additional information."
echo " "
echo "======================================================================="

echo "BMC --> ME --> BIOS --> FD --> FRUSDR -> Reset SUT -> DCPMM"
pause


:A

if exist BMC_pass.tmp then 
    if exist ME_pass.tmp then 
        if exist BIOS_pass.tmp then 
            if exist FD_pass.tmp then
                if exist Frusdr_pass.tmp then 
                    comp firstresettemplate.log reset.tmp > nul
                    if %lasterror% == 0 then
                        echo "SUT reboot successfully after BIOS/BMC/FRUSDR update."
                        stall 3000000
                        goto DCPMMFW 
                    else
                        echo "SUT will be reset for making updated BIOS/BMC/FRUSDR effective."
                        echo 1 > reset.tmp
                        stall 10000000
                        reset -c
                    endif
                else
                     goto FRUSDR
                endif
            else
                goto FD
            endif
        else
            goto BIOS
        endif
    else 
        goto ME
    endif
else 
    goto BMC
endif


:BMC
echo " "
echo "DO NOT remove the USB flash drive"
echo " "
echo " "

#Update BMC
fwUpdateBMC.nsh
echo " "
echo "BMC Firmware update has been completed" > BMC_pass.tmp 
echo " "

stall 3000000
goto A


:BIOS
echo " "
echo "==============================================================================="
echo "Continuing system BIOS update......"
echo "DO NOT remove the USB flash drive"
echo " "
echo " "

#Update BIOS
UpdBIOS.nsh

echo " "
echo "BIOS Firmware update has been completed" > BIOS_pass.tmp 
echo " "


stall 3000000
goto A


:ME
echo " "
echo "==============================================================================="
echo "Continuing system ME update......"
echo "DO NOT remove the USB flash drive"
echo " "
echo "==============================================================================="
echo " "
echo " "

#Update ME
UpdMe.nsh

echo " "
echo "ME Firmware update has been completed" > ME_pass.tmp 
echo " "
echo

stall 3000000
goto A


:FD
echo " "
echo "==============================================================================="
echo "Continuing system Flash Description update......"
echo " "
echo " "

#Update FD
UpdFD.nsh

echo " "
echo "FD update has been completed" > FD_pass.tmp
echo " "
echo "==============================================================================="
echo "DO NOT remove the USB flash drive"
echo " "
echo "==============================================================================="

stall 3000000
goto A



:FRUSDR
echo " "
echo "==============================================================================="
echo "Continuing system FRUSDR update......"
echo "DO NOT remove the USB flash drive"
echo ""
echo " "

#Update FRUSDR
UpdS2600WF.nsh 


echo " "

echo " "
echo "System FRU & SDR data have successfully been updated" > Frusdr_pass.tmp 
stall 3000000
goto A

:DCPMMFW

echo " "
echo "==============================================================================="
echo "Continuing DCPMM Firmware update......"
echo " "
echo "DO NOT remove the USB flash drive"
echo " "
    
    ipmctl.efi show -dimm > noDCPMM.tmp 
    comp noDCPMM.log noDCPMM.tmp > comp.tmp 
    if %lasterror% == 0 then
        echo " "
        echo "No DCPMM DIMM installed, ignoring DCPMM FW Update" 
        echo " "
        goto final
    else
        echo " "
        echo "Found DCPMM DIMM installed"
        echo "Updating DCPMM firmware"
        echo " "
        stall 3000000
        #Update DCPMM
        UpdateDCPMMFW.nsh
    endif



:final
echo "Deleting temp files...."
del BMC_pass.tmp
del BIOS_pass.tmp
del ME_pass.tmp
del FD_pass.tmp
del Frusdr_pass.tmp
del reset.tmp
del noDCPMM.tmp
del comp.tmp

echo " "
echo "============================================================"
echo "All system updates have been completed now"
echo " "
echo "Now the USB Key can be removed and the system can be powered cycle."
echo "During POST, access the BIOS Setup utility via pressing <F2>"
echo "To confirm all updates have been installed properly."


:END
 